-- IGNORE ON DB-CREATE IF EXISTS GROUP 'SYS.Administratoren' : DB-Erstellung im Prodat überspringt diese Datei (TDBCreateForm.btReloadXXXClick)

-- externes Wiki          http://redmine.prodat-sql.de/projects/prodat-v12-public/wiki/Benutzer-_und_Benutzergruppen
-- intern inkl. extern    http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/System-Benuter_und_-Benutzergruppen

-- CREATE ROLE "SYS.BDE-Administratoren" NOSUPERUSER INHERIT NOCREATEDB NOCREATEROLE NOREPLICATION; -- kann wahrscheinlich weg. Nicht mehr benötigt, keine funktionale Gruppe (ist jetzt MM.BDE.VZ)
-- Standard-Prodat Benutzer. Keine strukturellen Rechte nur Daten bearbeiten.  Siehe Ticket 76


--- #20137 Funktion erstellt Role/Group, wenn nicht existiert ist
---        Direkte 'CREATE GROUP' beim Ausführung PowerSchell-Projekt, wirft Fehler
CREATE OR REPLACE FUNCTION TSystem.create__role_group(
        IN _user       varchar,
        IN _role_group varchar,
        IN _params     varchar default null
    ) RETURNS void AS $$
  BEGIN
    IF NOT EXISTS ( SELECT true FROM pg_catalog.pg_roles WHERE rolname = _user ) THEN
      EXECUTE concat_ws(' ', 'CREATE', _role_group, quote_ident(_user), _params, ';');
  ELSE
      raise notice '% % ist schon existiert', _role_group, quote_ident(_user);
    END IF;
    RETURN;
  END $$ LANGUAGE plpgsql;
---
SELECT TSystem.create__role_group( 'SYS.Prodat-User', 'ROLE', $$ NOSUPERUSER INHERIT NOCREATEDB NOCREATEROLE REPLICATION $$);  -- neue Rolle/Gruppe für NOSUPERUSER, z.B. 'TC'
SELECT TSystem.create__role_group( 'SYS.Faktura.Kreditoren', 'GROUP' );    -- Rechnungen eingangsseitig anlegen und editieren
SELECT TSystem.create__role_group( 'SYS.Faktura', 'GROUP' );   -- Assistent Rechnungen Ausgangsseitig
SELECT TSystem.create__role_group( 'SYS.Faktura.AR-Freigabe', 'GROUP' );   -- Gruppenmitglieder dürfen andere Ausgangsrechnungen sehen
SELECT TSystem.create__role_group( 'SYS.Lager', 'GROUP' );    -- Assistent Lager
SELECT TSystem.create__role_group( 'SYS.Controlling, Umsatzzahlen', 'GROUP' );    -- Assistent Controlling

SELECT TSystem.create__role_group( 'SYS.Administratoren', 'GROUP', $$ CREATEROLE $$ );    -- Grundgruppe -> Menuberechtigungen

SELECT TSystem.create__role_group( 'SYS.Personaldaten', 'GROUP' );     -- Personaldaten sind zu sehen
SELECT TSystem.create__role_group( 'SYS.Personaldaten.PrivTel', 'GROUP' );    -- Personaldaten - private Telefonnummern
SELECT TSystem.create__role_group( 'SYS.Personaldaten.QM', 'GROUP' );   -- Tab Qualifikationen sind im Personalwesen zu sehen
SELECT TSystem.create__role_group( 'SYS.Personaldaten.AbwBewill.ALohneRecht', 'GROUP' );  -- für Abw-Bewilligungen für Mitarbeiter mit Recht ll_urlaub_bewill_notself

-- TODO: Syntax?
SELECT TSystem.create__role_group( 'SYS.Adressen.Umschreiben', 'GROUP' );    -- Darf Adresskuerzel umschreiben und Adressen zusammenfuehren

-- TODO: Syntax? -> SYS.DMS.Vollzugriff???
SELECT TSystem.create__role_group( 'SYS.Dokumente-Admin', 'GROUP' );

--Plantafel
SELECT TSystem.create__role_group( 'SYS.PT.Plantafel-Admin', 'GROUP' );
SELECT TSystem.create__role_group( 'SYS.PT.Plantafel-Worker', 'GROUP' );
SELECT TSystem.create__role_group( 'SYS.PT.Plantafel-Fixwoche-Admin', 'GROUP' );

-- TODO: Syntax?
SELECT TSystem.create__role_group( 'SYS.ER-Freigabe', 'GROUP' );   -- Gruppenmitglieder dürfen Eingangsrechnungen zur Bezahlung freigeben, dürfen andere eingangsrechnungen sehen

-- TODO: Syntax? -> SYS.LAG. (oben gruppe assist         en mit anpassen)
SELECT TSystem.create__role_group( 'SYS.Lager-Haenel', 'GROUP' );
SELECT TSystem.create__role_group( 'SYS.Lager-Lagerort', 'GROUP' );  -- Lagerorte anlegen dürfen (OG) Demo-Daten-Anlegen verwendet Ort
SELECT TSystem.create__role_group( 'SYS.Lieferschein.Adressen.Umschreiben', 'GROUP' );  -- Im Lieferschein darf Liefer und Rechnungsadresse umgeschrieben werden
SELECT TSystem.create__role_group( 'SYS.DebiKrediDat', 'GROUP' ); -- (OG) Demo-Daten-Anlegen verwendet Ort

-- TODO: Syntax? -> SYS.QS.
SELECT TSystem.create__role_group( 'SYS.QAB-Admin', 'GROUP' );
SELECT TSystem.create__role_group( 'SYS.QAB-Neu-Infomail', 'GROUP' );
SELECT TSystem.create__role_group( 'SYS.QAB-Wirksam-Infomail', 'GROUP' );
SELECT TSystem.create__role_group( 'SYS.QAB-Extern-Neu-Infomail', 'GROUP' );
SELECT TSystem.create__role_group( 'SYS.QAB-Auswaerts-Neu-Infomail', 'GROUP' );
SELECT TSystem.create__role_group( 'SYS.QAB-Retoure-Infomail', 'GROUP' );
SELECT TSystem.create__role_group( 'SYS.QAB-Kontrolle', 'GROUP' );
SELECT TSystem.create__role_group( 'SYS.WEB-Pruefer', 'GROUP' );
SELECT TSystem.create__role_group( 'SYS.WEB-Admin', 'GROUP' );

SELECT TSystem.create__role_group( 'SYS.Arbeitsschutz', 'GROUP' );  --- #18352

-- im PRODAT > Systemprogramme > Konfiguration > Benutzerverwaltung > Benutzergruppen
-- TFormGroups.ServSqlGroupsBeforeInsert und TFormGroups.ServSqlGroupsBeforeDelete
--CREATE GROUP &groname
--DROP GROUP &groname

-- im PRODAT > Systemprogramme > Konfiguration > Benutzerverwaltung > Benutzergruppen > ToolBar: Mitglider
-- im PRODAT > Systemprogramme > Konfiguration > Benutzerverwaltung > Benutzerverwaltung > ToolBar: Benutzergruppen
-- TFormGroupUsers.BtGrantClick  und TFormGroupUsers.BtDelGrantClick
-- TFormUsersGroups.BtGrantClick und TFormUsersGroups.BtDelGrantClick
--ALTER GROUP &groname ADD USER &usename
--ALTER GROUP &groname DROP USER &usename

--- #18079 Gruppenrechte zuweisen für Sys.Administratoren "WITH admin Sys.Administratoren" => ACHTUNG AUCH ÄHNLICH IN StandardSQL System.MM.Standard.userrights FÜR Goup MM.%
-- SYS.Administratoren darf diese Gruppen somit administrieren
DO $$
   DECLARE rec RECORD;
   BEGIN
    FOR rec IN SELECT *
                 FROM pg_group
                WHERE groname NOT iLIKE 'SYS.Administratoren'
                  AND groname NOT iLIKE 'pg_%'
                  AND groname iLIKE 'SYS.%'
               ORDER BY 1
    LOOP

        EXECUTE 'GRANT ' || quote_ident( rec.groname ) || ' TO "SYS.Administratoren" WITH ADMIN OPTION;';

    END LOOP;
 END $$;
---

-- keine leeren Statements am Ende vom Erstellen der DB erlaubt.
SELECT true;

